#include <bits/stdc++.h>
#include <bits/extc++.h>

#ifndef ASTRON
#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx,avx2,sse,sse2,sse3,ssse3,sse4,sse4.1,sse4.2,popcnt,abm,mmx,fma,tune=native")
#endif

using namespace std;
using namespace __gnu_pbds;

#define int long long
#define ld long double

template<typename T>
istream& operator>>(istream& in, vector<T> v) {
    for (T& i : v) in >> i;
    return in;
}

struct vec {
    ld x, y;

    vec(ld x, ld y) : x(x), y(y) {}

    vec operator-(vec o) const {
        return {x - o.x, y - o.y};
    }

    vec operator+(vec o) const {
        return {x + o.x, y + o.y};
    }

    bool operator==(vec o) const {
        return x == o.x && y == o.y;
    }

    bool operator!=(vec o) const {
        return !(operator==(o));
    }

    ld cross(vec o) const {
        return x * o.y - o.x * y;
    }

    ld dot(vec o) const {
        return x * o.x + y * o.y;
    }

    ld len() const {
        return sqrt(x*x+y*y);
    }


    bool operator<(const vec& o) const {
        if (abs(x - o.x) <= 1e-9 && abs(y - o.y) <= 1e-9) return false;

        if (x != o.x)
            return x < o.x;
        return y < o.y;
    }
};

ld sgn(ld q) {
    if (q < 0) return -1;
    if (q > 0) return 1;
    return 0;
}

struct seg {
    vec start, end;

    seg(vec start, vec end) : start(start), end(end) {}
    seg() : start(0 ,0), end(0 ,0) {}

    bool intersects(seg o) const {
        if (start == o.start || end == o.start || start == o.end || end == o.end)
            return true;

        vec cur = end - start;
        o.start = o.start - start;
        o.end = o.end - start;

        if (cur.cross(o.start) == 0) {
            if (cur.dot(o.start) / cur.len() <= cur.len() && cur.dot(o.start) >= 0)
                return true;
            else {
                return o.end == cur || o.end == vec(0, 0);
            }
        }

        if (cur.cross(o.end) == 0) {
            if (cur.dot(o.end) / cur.len() <= cur.len() && cur.dot(o.end) >= 0)
                return true;
            else
                return o.start == cur || o.start == vec(0, 0);
        }

        bool ok1 = sgn(cur.cross(o.start)) == -sgn(cur.cross(o.end));
        cur = start - end;
        o.start = o.start + start - end;
        o.end = o.end + start - end;

        bool ok2 = sgn(cur.cross(o.start)) == -sgn(cur.cross(o.end));
        return ok1 && ok2;
    }
};

struct line {
    ld a, b, c;
    line(seg s) {
        vec q = s.start;
        vec w = s.end;
        if (q.x == w.x) {
            b = 0;
            a = 1;
            c = -q.x;
            return;
        }

        ld k = (q.y - w.y) / (q.x - w.x);
        ld bq = q.y - k * q.x;
        a = -k;
        b = 1;
        c = -bq;
    }

    ld get(ld x) const {
        return (a * x + c) / -b;
    }

    vec cross(line o) const {
        if (b == 0) {
            return vec(-c, o.get(-c));
        }

        if (o.b == 0) {
            return vec(-o.c, get(-o.c));
        }

        ld k1 = a / -b;
        ld bq1 = c / -b;
        ld k2 = o.a / -o.b;
        ld bq2 = o.c / -o.b;

        ld x = (bq2 - bq1) / (k1 - k2);
        ld y = get(x);
        return vec(x, y);
    }
};

map<vec, vector<vec>> g;
set<vec> used;

int dfs(vec v, vec p) {
    int ans = 0;
    used.insert(v);

    for (vec u : g[v]) {
        if (used.count(u) && u != p) {
            ans++;
        }
    }

    for (vec u : g[v]) {
        if (used.count(u) && u != p) {
//            ans++;
        } else if (!used.count(u)) {
            ans += dfs(u, v);
        }
    }

    return ans;
}

void solve() {
    int n;
    cin >> n;
    vector<seg> segs(n);
    for (int i = 0; i < n; i++) {
        ld a, b, c, d;
        cin >> a >> b >> c >> d;
        segs[i] = seg(vec(a, b), vec(c, d));
    }

    g.clear();
    used.clear();

    vector<vec> allpoints;

    for (int i = 0; i < n; i++) {
        vector<vec> points;

        for (int j = 0; j < n; j++) {
            if (i == j) continue;
            if (segs[i].intersects(segs[j]) && segs[j].intersects(segs[i])) {
                vec p = line(segs[i]).cross(line(segs[j]));
//                cout << p.x << ' ' << p.y << " : ";

                points.push_back(p);
                allpoints.push_back(p);
            } else {
//                cout << "0 0 : ";
            }
        }

        sort(points.begin(), points.end(), [](vec &a, vec &b) {
            if (a.x != b.x)
                return a.x < b.x;
            return a.y < b.y;
        });

        for (int k = 0; k < (int) points.size() - 1; k++) {
            g[points[k]].push_back(points[k + 1]);
            g[points[k + 1]].push_back(points[k]);
        }
    }

    int ans = 0;

    vector<vec> vqqq = g[vec(2, 3)];

    for (vec v : allpoints) {
        if (!used.count(v))
            ans += dfs(v, vec(1e9+7, 1e9+7));
    }

    cout << ans + 1;
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t = 1;
    cin >> t;
    while (t--) solve(), cout << '\n';

    return 0;
}
